Attribute VB_Name = "modSystem"
'-----------------------------------------------------
' MirageBot System Information Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public Declare Function GetUserDefaultLCID Lib "kernel32" () As Long
Public Declare Function GetUserDefaultLangID Lib "kernel32" () As Long
Public Declare Function GetSystemDefaultLCID Lib "kernel32" () As Long
Public Declare Function GetSystemDefaultLangID Lib "kernel32" () As Long

Private Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long
Private Declare Function GetModuleHandle Lib "kernel32" Alias "GetModuleHandleA" (ByVal lpModuleName As String) As Long
Private Declare Function GetCurrentProcess Lib "kernel32" () As Long
Private Declare Function IsWow64Process Lib "kernel32" (ByVal hProc As Long, bWow64Process As Boolean) As Long

Private Declare Function GetLocaleInfoA Lib "kernel32" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function SHGetSpecialFolderLocation Lib "shell32" (ByVal hwnd As Long, ByVal nFolder As Long, ppidl As Long) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32" Alias "SHGetPathFromIDListA" (ByVal Pidl As Long, ByVal pszPath As String) As Long
Private Declare Sub CoTaskMemFree Lib "ole32" (ByVal pvoid As Long)

Public Const LOCALE_SENGLANGUAGE              As Long = &H1001
Public Const LOCALE_USER_DEFAULT              As Long = &H400
Public Const LOCALE_SABBREVLANGNAME           As Long = &H3
Public Const LOCALE_SENGCOUNTRY               As Long = &H1002
Public Const LOCALE_SABBREVCTRYNAME           As Long = &H7
Public Const LOCALE_SNATIVECTRYNAME           As Long = &H8
Public Const LOCALE_SISO3166CTRYNAME          As Long = &H5A
Public Const LOCALE_SISO639LANGNAME           As Long = &H59

Private Const CSIDL_PERSONAL                  As Long = &H5
Private Const CSIDL_APPDATA                   As Long = &H1A
Private Const CSIDL_DESKTOPDIRECTORY          As Long = &H10
Private Const MAX_PATH                        As Long = 260
Private Const NOERROR                         As Long = 0

Private Declare Function GetVolumeSerialNumber Lib "kernel32" Alias "GetVolumeInformationA" (ByVal lpRootPathName As String, ByVal lpVolumeNameBuffer As String, ByVal nVolumeNameSize As Long, lpVolumeSerialNumber As Long, lpMaximumComponentLength As Long, lpFileSystemFlags As Long, ByVal lpFileSystemNameBuffer As String, ByVal nFileSystemNameSize As Long) As Long

Public Sub TryNudge(Index As Integer, Username As String, Optional Message As String)
On Error GoTo hErr
    If Options.Nudge = True Then Exit Sub
    Static NudgeWarning As Boolean
    Dim B As BNCS
    Set B = frmBot.Bot(Index)
    If (GetTickCount - B.TickNudge > 60000) Then
        B.NudgeCount = 1
        B.TickNudge = GetTickCount()
        NudgeWarning = False
    Else
        B.NudgeCount = B.NudgeCount + 1
        If B.NudgeCount >= 10 Then
            If Not NudgeWarning Then
                OutputEvent frmBot.rtbChat(Index), &HB2, , "Nudges have been temporarily disabled. It appears that someone tried to exploit this feature, it will be re-enabled after a small grace period."
                NudgeWarning = True
            End If
            Exit Sub
        End If
    End If
    frmBot.ZOrder vbBringToFront
    If frmBot.Visible = False Or frmBot.WindowState = vbMinimized Then
        frmTray.TrayBalloon vbExclamationIcon, B.Self.Username & " Got Nudged!", Username & IIf(Len(Message), ": " & Message, "!")
    Else
        FlashWindow
    End If
    PlaySound App.Path & "\notify.wav", SND_ASYNC
    OutputEvent frmBot.rtbChat(Index), &HB0, , "Nudge received from " & Username & IIf(Len(Message), ": " & Message, "!")
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "System", "TryNudge"
End Sub

Private Function VolumeSerialNumber(ByVal RootPath As String) As String
    Dim VolLabel As String
    Dim VolSize As Long
    Dim Serial As Long
    Dim MaxLen As Long
    Dim Flags As Long
    Dim Name As String
    Dim NameSize As Long
    Dim S As String
    Dim ret As Boolean
    ret = GetVolumeSerialNumber(RootPath, VolLabel, VolSize, Serial, MaxLen, Flags, Name, NameSize)
    If ret Then
        S = Format$(Hex(Serial), "00000000")
        VolumeSerialNumber = Left$(S, 4) & Right$(S, 4)
    Else
        VolumeSerialNumber = "00000000"
    End If
End Function

Public Function GenerateSerial() As String
    Dim vs As String
    vs = VolumeSerialNumber(Left$(App.Path, 3))
    If vs = "00000000" Then
        GenerateSerial = vbNullString
    Else
        GenerateSerial = vs
    End If
End Function

Private Function SpecFolder(ByVal lngFolder As Long) As String
On Error GoTo hErr
    Dim lngPidlFound As Long, lngFolderFound As Long, lngPidl As Long, strPath As String
    strPath = Space$(MAX_PATH)
    lngPidlFound = SHGetSpecialFolderLocation(0, lngFolder, lngPidl)
    If lngPidlFound = NOERROR Then
        lngFolderFound = SHGetPathFromIDList(lngPidl, strPath)
        If lngFolderFound Then SpecFolder = Left$(strPath, InStr(1, strPath, vbNullChar) - 1)
    End If
    CoTaskMemFree lngPidl
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "System", "SpecFolder"
End Function

Public Function AppSettings() As String
    AppSettings = AppData & "Data\Preferences\Settings.ini"
End Function

Public Function AppData() As String
On Error GoTo hErr
    If PORTABLE Then
        AppData = App.Path & "\"
    Else
        'If TestIDE Then
        '    AppData = "C:\Users\Chriso\AppData\Roaming\MirageBot\"
        'Else
            AppData = SpecFolder(CSIDL_APPDATA) & "\MirageBot\"
        'End If
    End If
    CreateFolder AppData
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "System", "AppData"
End Function

Public Function GetLocaleInfo(ByVal lInfo As Long) As String
On Error GoTo hErr
    Dim Buffer As String, ret As Long
    Buffer = String$(256, vbNullChar)
    ret = GetLocaleInfoA(LOCALE_USER_DEFAULT, lInfo, Buffer, Len(Buffer))
    If (ret > 0) Then GetLocaleInfo = Left$(Buffer, ret - 1)
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "System", "GetLocaleInfo"
End Function

Public Function GetRegion() As Long
On Error GoTo hErr
    Dim Region As String * 4
    Region = GetLocaleInfo(LOCALE_SISO639LANGNAME) & GetLocaleInfo(LOCALE_SISO3166CTRYNAME)
    GetRegion = ExtractInt32(Replace$(Region, Space$(1), vbNullChar))
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "System", "GetRegion"
End Function

Public Sub ApplyIcons(Handle As Long)
On Error GoTo hErr:
    If Options.Icons = 1 Then
        SendMessage Handle, LVM_SETIMAGELIST, LVSIL_SMALL, ByVal frmBot.imlClassic.hImageList
    ElseIf Options.Icons = 2 Then
        SendMessage Handle, LVM_SETIMAGELIST, LVSIL_SMALL, ByVal frmBot.imlModern.hImageList
    Else
        SendMessage Handle, LVM_SETIMAGELIST, LVSIL_SMALL, ByVal frmBot.imlAvatar.hImageList
    End If
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "System", "ApplyIconSetAPI"
End Sub


